function [Gapz,infeas,time_vec,X,D,y] = RPDCG(gradX,gradD,grady,X0,D0,y0,param)

disp('***R-PDCG Starts***');
% initialization and parameter selection
X = X0;
D = D0;
y = y0;
maxiter = param.maxiter;
tau = param.tau;
mu = param.mu;
r = param.r;
B = param.B;
[m,q] = size(D);
Gapz_min = inf;
Gapz = [];
sk1 = sparse(m,q);
aux = eye(m,q);
time_vec = [];
infeas = [];
elaps = 0;
% main steps
for i = 1:maxiter
    tic;
    GX = gradX(D,X,y); % gradient w.r.t C
    GD = gradD(D,X,y); % gradient w.r.t D
    Gy = grady(D,X,y); % gradient w.r.t y
    GyR = grady(D,X,y)-mu*(y-y0); % gradient w.r.t y for regularized function
    ind = sum_square(GD)==0;
    sk1(:,ind) = aux(:,ind);
    sk1(:,~ind) = -GD(:,~ind)./sqrt(sum_square(GD(:,~ind)));
    [u,~,v] = svds(GX,1);
    sk2 = -r*sparse(u)*sparse(v');
    
    pk = (GyR/norm(GyR)*B/2)+B/2;
    sig = min(1,1/(4*sqrt(B^2/2)*(mu))*norm(GyR));

    D_new = (1-tau)*D+tau*sk1;
    X_new = (1-tau)*X+tau*sk2;
    y_new = (1-sig)*y+sig*pk;

    time_iter = toc;

    % calculating the gap function
    pk2 = (Gy/norm(Gy)*B/2)+B/2;
    if i<maxiter/2
        Gapz = [Gapz;trace(GX'*(X-sk2))+trace(GD'*(D-sk1))+(Gy)'*(pk2-y)];
        infeas = [infeas;pos(grady(D,X,y))];
    else
        Gapz_min = min(abs(Gapz_min),trace(GX'*(X-sk2))+trace(GD'*(D-sk1))+(Gy)'*(pk2-y));
        Gapz = [Gapz;Gapz_min];
        infeas = [infeas;pos(Gy)];
    end
    D = D_new;
    X = X_new;
    y = y_new;
    elaps = elaps+time_iter;
    time_vec = [time_vec;elaps];
end
disp('***R-PDCG is Done!***');
end